// To parse this JSON data, do
//
//     final nomineeResponseModel = nomineeResponseModelFromJson(jsonString);

import 'dart:convert';

import 'package:viserpay/data/model/global/meassage_model.dart';
import 'package:viserpay/data/model/global/userdata/global_user_data.dart';

NomineeResponseModel nomineeResponseModelFromJson(String str) => NomineeResponseModel.fromJson(json.decode(str));

String nomineeResponseModelToJson(NomineeResponseModel data) => json.encode(data.toJson());

class NomineeResponseModel {
  final String? remark;
  final String? status;
  final Message? message;
  final GlobalUserDetailsData? data;

  NomineeResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory NomineeResponseModel.fromJson(Map<String, dynamic> json) => NomineeResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null ? null : Message.fromJson(json["message"]),
        data: json["data"] == null ? null : GlobalUserDetailsData.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message": message?.toJson(),
        "data": data?.toJson(),
      };
}
